#include <stdlib.h>
#include <math.h>

struct state{
  double sqrtPI;
  double sqrttwo;
  double twosqrttwo;
  
  double *ranges;
  int last_pt;
  double *beta_c;
  double *alpha;
  double *gamma_;
  double *u; 
  double *n_u_sq;
  double *exp_n_u_sq;
  double fovR2;
  
  int nu;
  double du;
  double dr;
};


#ifdef DEBUG
#define DPRINTF(x...) printf(x)
#else
#define DPRINTF(x...) 
#endif


double
rec_func(int n_th, int first_pt, double divlR2, struct state *tables){
  
  double ret;
  int npts=tables->last_pt-first_pt+1;
  int i,j;
  double *ks,*kern;
  double kssum, bksum=0.0;
  double rfac, fovf, divf;

  ks=malloc(tables->nu*sizeof(double));
  kern=malloc(npts*sizeof(double));

  if(n_th==2){
	for(i=first_pt;i<tables->last_pt;i++){
	  kssum=0.0;
	  rfac= tables->alpha[i]/(tables->ranges[tables->last_pt]-tables->ranges[i]);
	  DPRINTF ("rfac-1 = %f\n",rfac); 
	  rfac=rfac*rfac*exp(4*tables->gamma_[i]*tables->gamma_[i]);
	  DPRINTF ("rfac-2 = %f\n",rfac);
	  fovf=tables->fovR2*rfac;
	  DPRINTF ("fovf = %f\n",fovf);
	  divf=divlR2*rfac;
	  DPRINTF ("divf = %f\n",divf); 
	  for(j=0;j<tables->nu;j++){
		kssum+= ks[j] = exp(tables->n_u_sq[j]-fovf/(exp(-tables->twosqrttwo*tables->gamma_[i]*tables->u[j])+divf));
		DPRINTF ("ks[%2i] = %f\n",j,ks[j]); 
	  }
	  bksum+=tables->beta_c[i]*(kern[i-first_pt]=tables->du*(kssum-ks[0]/2-ks[tables->nu-1]/2));
	  DPRINTF ("bksum = %f\n",bksum);
	}
	bksum+=tables->beta_c[tables->last_pt]*(kern[npts-1]=exp(-tables->fovR2/divlR2)/tables->sqrtPI);
	ret = (tables->dr*(bksum-tables->beta_c[first_pt]*kern[0]/2-tables->beta_c[tables->last_pt]*kern[npts-1]/2));
	DPRINTF ("returning %f\n",ret); 
  }else{
	double s;
	for(i=first_pt;i<=tables->last_pt;i++){
	  kssum=0.0;
	  rfac=((tables->ranges[tables->last_pt]-tables->ranges[i])/tables->alpha[i])*((tables->ranges[tables->last_pt]-tables->ranges[i])/tables->alpha[i]);
	  for(j=0;j<tables->nu;j++){
          s = divlR2 + rfac*exp(-tables->twosqrttwo*tables->gamma_[i]*(tables->u[j]+tables->sqrttwo*tables->gamma_[i]));
				 kssum+= ks[j] =tables->exp_n_u_sq[j]*rec_func(n_th-1,i,s,tables);
	  }
	  bksum+=tables->beta_c[i]*(kern[i-first_pt]=tables->du*(kssum-ks[0]/2-ks[tables->nu-1]/2));
	}
	ret=tables->dr*(bksum-tables->beta_c[first_pt]*kern[0]/2-tables->beta_c[tables->last_pt]*kern[npts-1]/2);
  }
  free(ks);
  free(kern);
  return ret;
}

double
ms_size_int_c (  int n_th, double *ranges, int first_pt, int last_pt, double *beta_c,
	       double *alpha, double *gamma_, int nu, double *u, double divlr2, double fovr2)
{
  double ret;
  struct state tables;
  int i;
  
  DPRINTF ("Starting up");

  tables.ranges=ranges;
  tables.last_pt=last_pt;
  tables.beta_c = beta_c;
  tables.alpha = alpha;
  tables.gamma_ = gamma_;
  tables.u = u;
  tables.fovR2 = fovr2;

  tables.sqrtPI = sqrt(M_PI);
  tables.sqrttwo = M_SQRT2;
  tables.twosqrttwo = 2.0*tables.sqrttwo;

  tables.nu = nu;
  tables.du=(u[1]-u[0])/tables.sqrtPI;
  tables.dr=ranges[1]-ranges[0];

  tables.n_u_sq=(double*)malloc(nu*sizeof(double));
  tables.exp_n_u_sq=(double*)malloc(nu*sizeof(double));

  for(i=0;i<nu;i++){
	tables.exp_n_u_sq[i] = exp(tables.n_u_sq[i]= -u[i]*u[i]);
  }

  DPRINTF (" - Working .."); 
	
  ret=rec_func(n_th, first_pt, divlr2,&tables);
  DPRINTF (" - Done\n"); 
  free(tables.n_u_sq);
  free(tables.exp_n_u_sq);
  return ret;
}
